<?php
/*
Template Name: League Standings
Template Post Type: page
*/
global $wpdb;
$selectedMonth='';
get_header();
?>
<main>

	<div class="wrapper_main">
		<div class="container">
			<div class="wrapper_content">
				<div class="title_wrapper">
					<div>
						<div class="icon_title">
							<?php include locate_template('assets/img/tales_icon_3.svg'); ?>
						</div>
						<h2 class="title"><?php the_title() ?></h2>
					</div>
					<?php get_template_part('template-parts/back', 'button') ?>
				</div>
				<div class="content_box">
					<div class="module_box_info">
						<form class="header_top header_top_2 box_shadow" >
							<input type="hidden" name="action" value="poker_league_filter">
							<input type="submit" style="display:none;">

							<div class="left_box">
								<div class="wrapper_sort_box">

									<?php
								/*	$sort_fields = [
										'player_rank' => 'Rank',
										'player_id' => 'Player',
										'games' => 'Games',
										'top3' => 'Top 3',
										'top10' => 'Top 10',
										'top20' => 'Top 20',
										'total_points' => 'Total Points',
									];
									$sort_order_fields = [
										'asc' => 'Ascending Order',
										'desc' => 'Descending'
									];
									$filter_blocks = [
										poker_FilterOptions::createBlock('Month:', 'filter[month]', poker_FilterOptions::getMonths()),
										poker_FilterOptions::createBlock('Year:', 'filter[year]', poker_FilterOptions::getRange(date('Y'), 1995, -1)),
										poker_FilterOptions::createBlock('Sort by:', 'sort[field]', $sort_fields),
										poker_FilterOptions::createBlock('In:', 'sort[order]', $sort_order_fields),
									];
*/
									
									?>
										<div class="sort_box">
											<div class="title">
											
													<span class="value">
														Month:&nbsp;<select  id='monthSelect' >
                                                          
				                                    <?php 
														for($i=1; $i<=12; $i++)
														{
															echo "<option value='$i'>$i</option>";
														}
														?>
														</select>
														<span class="icon">
															<?php include locate_template('assets/img/sort_table.svg'); ?>
														</span>
													</span>
											
											</div>
										</div>
										<div class="sort_box">
											<div class="title">
											
													<span class="value">
														Year:&nbsp;<select  id='yearSelect' >
                                                          <?php 
														$current_year = date('Y');
														for($i=$current_year; $i>=2008; $i--)
														{
															echo "<option value='$i'>$i</option>";
														}
														?>
				                           
														</select>
														<span class="icon">
															<?php include locate_template('assets/img/sort_table.svg'); ?>
														</span>
													</span>
											
											</div>
										</div>
										<div class="sort_box">
											<div class="title">
											
													<span class="value">
														Sort by:&nbsp;<select  id='sortBySelect' >
                                                          
														<option value='rank' selected>Rank</option> 
														<option value='nickname'>Nickname</option>
														<option value='playerid'>League ID</option>
														<option value='wins20'>Top 20's</option>
														<option value='wins10'>Top 10's</option>
														<option value='wins3'>Top 3's</option>
														<option value='games'>Games played</option>
														<option value='totalpts'>Points</option>

											
														</select>
														<span class="icon">
															<?php include locate_template('assets/img/sort_table.svg'); ?>
														</span>
													</span>
											
											</div>
										</div>
									<div class="sort_box">
											<div class="title">
											
													<span class="value">
														In:&nbsp;<select  id='ascSelect' >
                                                          
				                                <option value='asc' selected>Ascending</option>
												   <option value='desc'>Descending</option>
														</select>
														<span class="icon">
															<?php include locate_template('assets/img/sort_table.svg'); ?>
														</span>
													</span>
											
											</div>
										</div>

								</div>
							</div>
							<div class="right_box">
								<div class="sort_box sort_box_2">

									<div class="title">
											<span class="value">
												Show:&nbsp;<select  id='showSelect' >
												<option value='25' selected>25</option>
												<option value='50'>50</option>         
												<option value='75'>75</option>      
												<option value='100'>100</option>      
												<option value='200'>200</option>
												
												</select>
												<span class="icon">
													<?php include locate_template('assets/img/sort_table.svg'); ?>
												</span>
											</span>

									</div>
								</div>
							</div>
						</form>
						<div class="wrapper_table noOverflow" style="margin-bottom: 15px;">
							<table class="main_table main_table_2 datatable">
								<thead>
									<tr>
										<td>Rank</td>
										<td>Player</td>
										<td>Games</td>
										<td>Top 3</td>
										<td>Top 10</td>
										<td>Top 20</td>
										<td>Total Points</td>
									</tr>
								</thead>
								<tbody id="filter-results1">

								</tbody>
							

							</table>
   

						</div>
	
						
					</div>

					<?php
					get_template_part('template-parts/banner');
					get_template_part('template-parts/member', 'card');
					?>
				</div>
				<?php get_sidebar() ?>
			</div>
		</div>
	</div>
</main>
<script>
									$(document).ready(function(){
/*MAIN */
										var dat=[];
var endpoint='<?php echo admin_url('admin-ajax.php'); ?>';
										var formdata=new FormData;										
var selectedMonth=$( "#monthSelect option:selected" ).text();
var selectedYear=$( "#yearSelect option:selected" ).text();

var show=$( "#showSelect" ).val();
var sortIn=$( "#ascSelect" ).val();
var sortBy=$('#sortBySelect').val();
											
							//alert("month:"+selectedMonth,"year:"+selectedYear,show,sortIn,sortBy);				
formdata.append('action','enquiry');
formdata.append('month',selectedMonth);
formdata.append('year',selectedYear);
formdata.append('sortBy',sortBy);
formdata.append('sortIn',sortIn);
formdata.append('show',show);
$.ajax(endpoint,{
	type:'POST',
	data:formdata,
    processData:false,
	contentType:false,
	
	success:function(res)
	{
		
//ar dat=JSON.parse(res);		console.log(dat[0].nickname);
$('.main_table tbody').empty();
 dat=JSON.parse(res);
console.log(dat);
		for(var i=0; i<show; i++)
			{
			var redirect=dat[i].nickname.replace(/\s+/g, '-');

						var top3=dat[i].wins3/dat[i].games*100;
				        var top3_dec=top3.toFixed(2);
				         if(isNaN(top3_dec)){ top3_dec=0;}
				        var top10=dat[i].wins10/dat[i].games*100;
				        var top10_dec=top10.toFixed(2);
				      if(isNaN(top10_dec)){ top10_dec=0;}
				        var top20=dat[i].wins20/dat[i].games*100;
				        var top20_dec=top20.toFixed(2);
				        if(isNaN(top20_dec)){ top20_dec=0;}
				$('.main_table tbody').append('<tr><td>'+dat[i].prank+'</td><td><a style="color:#fff!important;" href="https://dev.anytwocards.com/personal-page/'+redirect+'/">'+dat[i].nickname+' </a><p class="pId">id: '+dat[i].playerid+'</p></td><td>'+dat[i].games+'</td><td>'+dat[i].wins3+' <p class="percentage">'+top3_dec+'%</p></td><td>'+dat[i].wins10+' <p class="percentage">'+top10_dec+'%</p></td><td>'+dat[i].wins20+' <p class="percentage">'+top20_dec+'%</p></td><td>'+dat[i].totalpts+' </td>');
			}
		$('.module_box_info').append('<button type="button" data-show="'+show+'" class=" btn btn-warning prevBtn" style="margin-right:10px;cursor:pointer;border:0px; border-radius:12px; padding:5.5px 15px;" >Previous 25</button><button type="button" data-show="'+show+'" class=" btn btn-warning nextBtn" style="cursor:pointer;border:0px; border-radius:12px; padding:5.5px 15px;" >Next 25</button>');
    
  
	}
})
$('.module_box_info').on('click','.nextBtn', function(){
	var showed=$(this).attr('data-show');
	showed=parseInt(showed);
	var next=showed+25;
	$(this).attr('data-show',next);
	$('.prevBtn').attr('data-show',next);
	$('.main_table tbody').empty();
    for(var i = showed; i<next; i++)
		{
		var redirect=dat[i].nickname.replace(/\s+/g, '-');

						var top3=dat[i].wins3/dat[i].games*100;
				        var top3_dec=top3.toFixed(2);
				         if(isNaN(top3_dec)){ top3_dec=0;}
				        var top10=dat[i].wins10/dat[i].games*100;
				        var top10_dec=top10.toFixed(2);
				      if(isNaN(top10_dec)){ top10_dec=0;}
				        var top20=dat[i].wins20/dat[i].games*100;
				        var top20_dec=top20.toFixed(2);
				        if(isNaN(top20_dec)){ top20_dec=0;}
				$('.main_table tbody').append('<tr><td>'+dat[i].prank+'</td><td><a style="color:#fff!important;" href="https://dev.anytwocards.com/personal-page/'+redirect+'/">'+dat[i].nickname+' </a><p class="pId">id: '+dat[i].playerid+'</p></td><td>'+dat[i].games+'</td><td>'+dat[i].wins3+' <p class="percentage">'+top3_dec+'%</p></td><td>'+dat[i].wins10+' <p class="percentage">'+top10_dec+'%</p></td><td>'+dat[i].wins20+' <p class="percentage">'+top20_dec+'%</p></td><td>'+dat[i].totalpts+' </td>');
		}

});
										$('.module_box_info').on('click','.prevBtn', function(){
	var showed=$(this).attr('data-show');
	showed=parseInt(showed);
	var prev=showed-25;
	if(showed >= 25)
	{
		
	
	$(this).attr('data-show',prev);
	$('.nextBtn').attr('data-show',prev);
	$('.main_table tbody').empty();
    for(var i = showed; i>prev; i--)
		{
		var redirect=dat[i].nickname.replace(/\s+/g, '-');

						var top3=dat[i].wins3/dat[i].games*100;
				        var top3_dec=top3.toFixed(2);
				         if(isNaN(top3_dec)){ top3_dec=0;}
				        var top10=dat[i].wins10/dat[i].games*100;
				        var top10_dec=top10.toFixed(2);
				      if(isNaN(top10_dec)){ top10_dec=0;}
				        var top20=dat[i].wins20/dat[i].games*100;
				        var top20_dec=top20.toFixed(2);
				        if(isNaN(top20_dec)){ top20_dec=0;}
				$('.main_table tbody').append('<tr><td>'+dat[i].prank+'</td><td><a style="color:#fff!important;" href="https://dev.anytwocards.com/personal-page/'+redirect+'/">'+dat[i].nickname+' </a><p class="pId">id: '+dat[i].playerid+'</p></td><td>'+dat[i].games+'</td><td>'+dat[i].wins3+' <p class="percentage">'+top3_dec+'%</p></td><td>'+dat[i].wins10+' <p class="percentage">'+top10_dec+'%</p></td><td>'+dat[i].wins20+' <p class="percentage">'+top20_dec+'%</p></td><td>'+dat[i].totalpts+' </td>');
		}
	}

});	
/*MAIN END*/ 



										/*Month change */
										$('#monthSelect').change(function(){
											var endpoint='<?php echo admin_url('admin-ajax.php'); ?>';
										var formdata=new FormData;										
var selectedMonth=$( "#monthSelect option:selected" ).text();
var selectedYear=$( "#yearSelect option:selected" ).text();

var show=$( "#showSelect" ).val();
var sortIn=$( "#ascSelect" ).val();
var sortBy=$('#sortBySelect').val();
											
							//alert("month:"+selectedMonth,"year:"+selectedYear,show,sortIn,sortBy);				
formdata.append('action','enquiry');
formdata.append('month',selectedMonth);
formdata.append('year',selectedYear);
formdata.append('sortBy',sortBy);
formdata.append('sortIn',sortIn);
formdata.append('show',show);
$.ajax(endpoint,{
	type:'POST',
	data:formdata,
    processData:false,
	contentType:false,
	
	success:function(res)
	{
		
//ar dat=JSON.parse(res);		console.log(dat[0].nickname);
$('.main_table tbody').empty();
var dat=JSON.parse(res);
		console.log(dat);
		for(var i=0; i<show; i++)
			{
						var redirect=dat[i].nickname.replace(/\s+/g, '-');

						var top3=dat[i].wins3/dat[i].games*100;
				        var top3_dec=top3.toFixed(2);
				         if(isNaN(top3_dec)){ top3_dec=0;}
				        var top10=dat[i].wins10/dat[i].games*100;
				        var top10_dec=top10.toFixed(2);
				      if(isNaN(top10_dec)){ top10_dec=0;}
				        var top20=dat[i].wins20/dat[i].games*100;
				        var top20_dec=top20.toFixed(2);
				        if(isNaN(top20_dec)){ top20_dec=0;}
				$('.main_table tbody').append('<tr><td>'+dat[i].prank+'</td><td><a style="color:#fff!important;" href="https://dev.anytwocards.com/personal-page/'+redirect+'/">'+dat[i].nickname+' </a><p class="pId">id: '+dat[i].playerid+'</p></td><td>'+dat[i].games+'</td><td>'+dat[i].wins3+' <p class="percentage">'+top3_dec+'%</p></td><td>'+dat[i].wins10+' <p class="percentage">'+top10_dec+'%</p></td><td>'+dat[i].wins20+' <p class="percentage">'+top20_dec+'%</p></td><td>'+dat[i].totalpts+' </td></tr>');
			}

    
   console.log(res);
	}
})
										});
										/* YEAR CHANGE */ 
$('#yearSelect').change(function(){
	var endpoint='<?php echo admin_url('admin-ajax.php'); ?>';
										var formdata=new FormData;										
var selectedMonth=$( "#monthSelect option:selected" ).text();
var selectedYear=$( "#yearSelect option:selected" ).text();

var show=$( "#showSelect" ).val();
var sortIn=$( "#ascSelect" ).val();
var sortBy=$('#sortBySelect').val();
											
											
formdata.append('action','enquiry');
formdata.append('month',selectedMonth);
formdata.append('year',selectedYear);
formdata.append('sortBy',sortBy);
formdata.append('sortIn',sortIn);
formdata.append('show',show);
$.ajax(endpoint,{
	type:'POST',
	data:formdata,
    processData:false,
	contentType:false,
	
	success:function(res)
	{
		$('.main_table tbody').empty();
//ar dat=JSON.parse(res);		console.log(dat[0].nickname);
var dat=JSON.parse(res);
		console.log(dat);
		for(var i=0; i<show; i++)
			{
						var redirect=dat[i].nickname.replace(/\s+/g, '-');

						var top3=dat[i].wins3/dat[i].games*100;
				        var top3_dec=top3.toFixed(2);
				         if(isNaN(top3_dec)){ top3_dec=0;}
				        var top10=dat[i].wins10/dat[i].games*100;
				        var top10_dec=top10.toFixed(2);
				      if(isNaN(top10_dec)){ top10_dec=0;}
				        var top20=dat[i].wins20/dat[i].games*100;
				        var top20_dec=top20.toFixed(2);
				        if(isNaN(top20_dec)){ top20_dec=0;}
				$('.main_table tbody').append('<tr><td>'+dat[i].prank+'</td><td><a style="color:#fff!important;" href="https://dev.anytwocards.com/personal-page/'+redirect+'/">'+dat[i].nickname+' </a><p class="pId">id: '+dat[i].playerid+'</p></td><td>'+dat[i].games+'</td><td>'+dat[i].wins3+' <p class="percentage">'+top3_dec+'%</p></td><td>'+dat[i].wins10+' <p class="percentage">'+top10_dec+'%</p></td><td>'+dat[i].wins20+' <p class="percentage">'+top20_dec+'%</p></td><td>'+dat[i].totalpts+' </td></tr>');
			}

    
	}
})
/* SORT BY CHANGE*/
										});
										$('#sortBySelect').change(function(){
											var endpoint='<?php echo admin_url('admin-ajax.php'); ?>';
										var formdata=new FormData;										
var selectedMonth=$( "#monthSelect option:selected" ).text();
var selectedYear=$( "#yearSelect option:selected" ).text();

var show=$( "#showSelect" ).val();
var sortIn=$( "#ascSelect" ).val();
var sortBy=$('#sortBySelect').val();
											
											
formdata.append('action','enquiry');
formdata.append('month',selectedMonth);
formdata.append('year',selectedYear);
formdata.append('sortBy',sortBy);
formdata.append('sortIn',sortIn);
formdata.append('show',show);
$.ajax(endpoint,{
	type:'POST',
	data:formdata,
    processData:false,
	contentType:false,
	
	success:function(res)
	{
		$('.main_table tbody').empty();
//ar dat=JSON.parse(res);		console.log(dat[0].nickname);
var dat=JSON.parse(res);
		console.log(dat);
		for(var i=0; i<show; i++)
			{
						var redirect=dat[i].nickname.replace(/\s+/g, '-');

						var top3=dat[i].wins3/dat[i].games*100;
				        var top3_dec=top3.toFixed(2);
				         if(isNaN(top3_dec)){ top3_dec=0;}
				        var top10=dat[i].wins10/dat[i].games*100;
				        var top10_dec=top10.toFixed(2);
				      if(isNaN(top10_dec)){ top10_dec=0;}
				        var top20=dat[i].wins20/dat[i].games*100;
				        var top20_dec=top20.toFixed(2);
				        if(isNaN(top20_dec)){ top20_dec=0;}
				$('.main_table tbody').append('<tr><td>'+dat[i].prank+'</td><td><a style="color:#fff!important;" href="https://dev.anytwocards.com/personal-page/'+redirect+'/">'+dat[i].nickname+' </a><p class="pId">id: '+dat[i].playerid+'</p></td><td>'+dat[i].games+'</td><td>'+dat[i].wins3+' <p class="percentage">'+top3_dec+'%</p></td><td>'+dat[i].wins10+' <p class="percentage">'+top10_dec+'%</p></td><td>'+dat[i].wins20+' <p class="percentage">'+top20_dec+'%</p></td><td>'+dat[i].totalpts+' </td></tr>');
			}

    
	}
})
										});
/*ORDER*/ 
										$('#ascSelect').change(function(){
											var endpoint='<?php echo admin_url('admin-ajax.php'); ?>';
										var formdata=new FormData;										
var selectedMonth=$( "#monthSelect option:selected" ).text();
var selectedYear=$( "#yearSelect option:selected" ).text();

var show=$( "#showSelect" ).val();
var sortIn=$( "#ascSelect" ).val();
var sortBy=$('#sortBySelect').val();
											
											
formdata.append('action','enquiry');
formdata.append('month',selectedMonth);
formdata.append('year',selectedYear);
formdata.append('sortBy',sortBy);
formdata.append('sortIn',sortIn);
formdata.append('show',show);
$.ajax(endpoint,{
	type:'POST',
	data:formdata,
    processData:false,
	contentType:false,
	
	success:function(res)
	{
		$('.main_table tbody').empty();
//ar dat=JSON.parse(res);		console.log(dat[0].nickname);
var dat=JSON.parse(res);
		console.log(dat);
		for(var i=0; i<show; i++)
			{
						var redirect=dat[i].nickname.replace(/\s+/g, '-');

						var top3=dat[i].wins3/dat[i].games*100;
				        var top3_dec=top3.toFixed(2);
				         if(isNaN(top3_dec)){ top3_dec=0;}
				        var top10=dat[i].wins10/dat[i].games*100;
				        var top10_dec=top10.toFixed(2);
				      if(isNaN(top10_dec)){ top10_dec=0;}
				        var top20=dat[i].wins20/dat[i].games*100;
				        var top20_dec=top20.toFixed(2);
				        if(isNaN(top20_dec)){ top20_dec=0;}
				$('.main_table tbody').append('<tr><td>'+dat[i].prank+'</td><td><a style="color:#fff!important;" href="https://dev.anytwocards.com/personal-page/'+redirect+'/">'+dat[i].nickname+' </a><p class="pId">id: '+dat[i].playerid+'</p></td><td>'+dat[i].games+'</td><td>'+dat[i].wins3+' <p class="percentage">'+top3_dec+'%</p></td><td>'+dat[i].wins10+' <p class="percentage">'+top10_dec+'%</p></td><td>'+dat[i].wins20+' <p class="percentage">'+top20_dec+'%</p></td><td>'+dat[i].totalpts+' </td></tr>');
			}

    
	}
})
										});
										
										//*SHOW*/
										$('#showSelect').change(function(){
											var endpoint='<?php echo admin_url('admin-ajax.php'); ?>';
										var formdata=new FormData;										
var selectedMonth=$( "#monthSelect option:selected" ).text();
var selectedYear=$( "#yearSelect option:selected" ).text();

//var sortIn=$( "#ascSelect option:selected" ).val();
//var show=$( "#showSelect option:selected" ).val();
var show=$( "#showSelect" ).val();
var sortIn=$( "#ascSelect" ).val();
var sortBy=$('#sortBySelect').val();		
											
formdata.append('action','enquiry');
formdata.append('month',selectedMonth);
formdata.append('year',selectedYear);
formdata.append('sortBy',sortBy);
formdata.append('sortIn',sortIn);
formdata.append('show',show);
$.ajax(endpoint,{
	type:'POST',
	data:formdata,
    processData:false,
	contentType:false,
	
	success:function(res)
	{
		$('.main_table tbody').empty();
//ar dat=JSON.parse(res);		console.log(dat[0].nickname);
var dat=JSON.parse(res);
		console.log(dat);
		for(var i=0; i<show; i++)
			{
						var redirect=dat[i].nickname.replace(/\s+/g, '-');

						var top3=dat[i].wins3/dat[i].games*100;
				        var top3_dec=top3.toFixed(2);
				         if(isNaN(top3_dec)){ top3_dec=0;}
				        var top10=dat[i].wins10/dat[i].games*100;
				        var top10_dec=top10.toFixed(2);
				      if(isNaN(top10_dec)){ top10_dec=0;}
				        var top20=dat[i].wins20/dat[i].games*100;
				        var top20_dec=top20.toFixed(2);
				        if(isNaN(top20_dec)){ top20_dec=0;}
				$('.main_table tbody').append('<tr><td>'+dat[i].prank+'</td><td><a style="color:#fff!important;" href="https://dev.anytwocards.com/personal-page/'+redirect+'/">'+dat[i].nickname+' </a><p class="pId">id: '+dat[i].playerid+'</p></td><td>'+dat[i].games+'</td><td>'+dat[i].wins3+' <p class="percentage">'+top3_dec+'%</p></td><td>'+dat[i].wins10+' <p class="percentage">'+top10_dec+'%</p></td><td>'+dat[i].wins20+' <p class="percentage">'+top20_dec+'%</p></td><td>'+dat[i].totalpts+' </td></tr>');
			}

    
	}
})
										});

});
									</script>

<?php get_footer(); ?>